<?php
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

$moduleCode = $_POST['module_code'];
$batchDate = $_POST['batch_date'];
$startSequence = (int)$_POST['start_sequence'];
$quantity = (int)$_POST['quantity'];

// 获取批次编码 (年份后两位 + 周数)
$dateObj = new DateTime($batchDate);
$weekNumber = $dateObj->format('W');
$batchWeekCode = $dateObj->format('y') . $weekNumber;

// 计算结束流水号
$endSequence = $startSequence + $quantity - 1;

// 获取模块名称
$moduleData = [
    'MGE1' => 'LR1302 LoRaWAN Gateway Module（EU868）',
    'MGU1' => 'LR1302 LoRaWAN Gateway Module（US915）',
    'MTR1' => 'nRFLR1110 LoRa Transceiver Module',
    'MTR2' => 'nRFLR1262 LoRa Transceiver Module',
    'MTR3' => 'nRFLR1121 LoRa Transceiver Module',
    'MTR4' => 'nRFLRCC68 LoRa Transceiver Module',
    'MTR5' => 'LR1262 LoRa Transceiver Module',
    'MTR6' => 'LRCC68 LoRa Transceiver Module',
    'MTR7' => 'LR1262 LoRaWAN Node Module',
    'G0EU1' => 'ThinkNode G1（EU868）',
    'G0EU2' => 'ThinkNode G3（EU868）',
    'G0US1' => 'ThinkNode G1（US915）',
    'G0US2' => 'ThinkNode G3（US915）',
    'G0AU1' => 'ThinkNode G3（AU915）',
    'G4EU1' => 'ThinkNode G3（EU868）',
    'G4US1' => 'ThinkNode G3（US915）',
    'G4AU1' => 'ThinkNode G3（AU915）',
    'TR1' => 'ThinkNode M1',
    'TR2' => 'ThinkNode M2',
    'CPI1' => 'CrowPi',
    'CPI2' => 'CrowPi2',
    'CPI3' => 'CrowPi L',
    'CTL1' => 'Crowtail STEAM Educational Kit for BBC Micro:bit',
    'CTL2' => 'Crowtail-Starter Kit for Micro:bit',
    'CVW1' => 'CrowView',
    'CVW2' => 'CrowView Note',
    'CVW3' => 'CrowView Yoga',
    'CPLB1' => 'CrowPanel 7.0"',
    'CPLB2' => 'CrowPanel 5.0"',
    'CPLA1' => 'CrowPanel Advance 7" HMI',
    'CPLA2' => 'CrowPanel Advance 5" HMI'
];

$moduleName = $moduleData[$moduleCode] ?? '未知模块';

// 获取批次号
$stmt = $conn->prepare("SELECT batch_number FROM batch_records WHERE module_code = ? AND LEFT(batch_week_code, 2) = RIGHT(YEAR(CURDATE()), 2) ORDER BY batch_number DESC limit 1");
$stmt->bind_param("s", $moduleCode);
$stmt->execute();
$result = $stmt->get_result();
$row = $result->fetch_assoc();
$batchNumber = $row['batch_number'] ? $row['batch_number'] + 1 : 1;

// 生成SN编码
$snCodes = [];
for ($i = 0; $i < $quantity; $i++) {
    $sequence = $startSequence + $i;
    $snCode = sprintf(
        "%s%s%03d%05d",
        $moduleCode,
        $batchWeekCode,
        $batchNumber,
        $sequence
    );
    $snCodes[] = [
        'module_name' => $moduleName,
        'date' => $batchDate,
        'batch_week_code' => $batchWeekCode,
        'batch_number' => sprintf("%03d", $batchNumber),
        'sequence' => sprintf("%05d", $sequence),
        'sn_code' => $snCode
    ];
}

/// 定义导出目录和文件名
$exportDir = 'exports/';
if (!is_dir($exportDir)) {
    mkdir($exportDir, 0777, true);
}
$fileName = 'SN_Codes_' . $moduleCode . '_' . date('YmdHis') . '.csv';
$filePath = $exportDir . $fileName;

// 保存批次记录
$stmt = $conn->prepare("INSERT INTO batch_records (module_code, module_name, batch_date, batch_week_code, batch_number, start_sequence, end_sequence, quantity, file_name) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssssiiiss", $moduleCode, $moduleName, $batchDate, $batchWeekCode, $batchNumber, $startSequence, $endSequence, $quantity, $fileName);
$stmt->execute();

// 设置CSV文件头并创建文件
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $fileName . '"');

// 将CSV内容写入文件
$output = fopen($filePath, 'w');

// 添加BOM以支持Excel中文显示
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// 写入CSV头
fputcsv($output, ['模块名称', '日期', '批次编码', '批次编号', '流水号', 'SN码']);

// 写入数据
foreach ($snCodes as $code) {
    fputcsv($output, [
        $code['module_name'],
        $code['date'],
        $code['batch_week_code'],
        $code['batch_number'],
        $code['sequence'],
        $code['sn_code']
    ]);
}

// 关闭文件句柄
fclose($output);

// 读取文件内容并输出给浏览器进行下载
readfile($filePath);

// 脚本结束，不需要重定向
exit;
?> 